/* *******************************************************************
GAUSS code: Exercise 1.8(c)
File: qs.g

Reference:
Bai, J. and Ng, S. (2005).
  Tests for skewness, kurtosis, and normality for time series 
  data.
  Journal of Business & Economic Statistics, 23(1), 49-60.
  DOI: 10.1198/073500104000000271.
******************************************************************** */
proc(1) = qs(u,prewhite);
local v,i,j,reg,n,nreg,beta,rho,sigma,b,r,fit,top,bot,alpha,vcv,hac,d,dum,k,w,cov,x;
local del;

n     = rows(u);
nreg  = cols(u);
rho   = zeros(nreg,1);
sigma = zeros(nreg,1);
d     = zeros(nreg,nreg);
beta  = zeros(nreg,nreg);

/* do a VAR(1) prewhitening */
if prewhite==1;
  v   = zeros(n-1,nreg);
  reg = u[1:n-1,.];
  i   = 1;
  do while i<=nreg;
    beta[.,i] = olsqr(u[2:n,i],reg);
    v[.,i]    = u[2:n,i]-reg*beta[.,i];
    i         = i+1;
  endo;
else;
  v = u;
endif;

rho = zeros(nreg,1);
i   = 1;
do while i<=nreg;
  {rho[i],r,fit} = olsqr2(v[2:rows(v),i],v[1:rows(v)-1,i]);
  sigma[i]       = r'r/rows(v);
  i              = i+1;
endo;

bot = 0;top = 0;
i = 1;
do while i<=nreg;
  top = top+4*(rho[i]^2)*sigma[i]^2/(1-rho[i])^8;
  bot = bot+sigma[i]^2/((1-rho[i])^4);
  i   = i+1;
endo;

alpha = top/bot;
k     = ceil(1.3221*(alpha*n)^(0.2));

vcv = v'v/(n-1);
i   = 1;
do while i<=n-1;
  x   = i/k;
  del = 6*pi*x/5;
  w   = 3*(sin(del)/del-cos(del))/(del*del);
  cov = v[i+1:rows(v),.]'v[1:rows(v)-i,.]/(n-1);
  vcv = vcv+w*cov;
  cov = v[1:rows(v)-i,.]'v[i+1:rows(v),.]/(n-1);
  vcv = vcv+w*cov;
  i   = i+1;
endo;

d   = inv(eye(nreg)-beta');
hac = d*vcv*d';
retp(hac);
endp;
